@extends('layouts.simple')

@section('body')

    <div class="container small">

        <div class="my-s">
            @include('entities.breadcrumbs', ['crumbs' => [
                $page->book,
                $page->chapter,
                $page,
                $page->getUrl('/delete') => [
                    'text' => trans('entities.pages_delete'),
                    'icon' => 'delete',
                ]
            ]])
        </div>

        <div class="card content-wrap auto-height">
            <h1 class="list-heading">{{ $page->draft ? trans('entities.pages_delete_draft') : trans('entities.pages_delete') }}</h1>

            @if($usedAsTemplate)
                <p class="text-warn">{{ trans('entities.pages_delete_warning_template') }}</p>
            @endif

            <div class="grid half v-center">
                <div>
                    <p class="text-neg">
                        <strong>
                            {{ $page->draft ? trans('entities.pages_delete_draft_confirm'): trans('entities.pages_delete_confirm') }}
                        </strong>
                    </p>
                </div>
                <div>
                    <form action="{{ $page->getUrl() }}" method="POST">
                        {!! csrf_field() !!}
                        <input type="hidden" name="_method" value="DELETE">
                        <div class="form-group text-right">
                            <a href="{{ $page->getUrl() }}" class="button outline">{{ trans('common.cancel') }}</a>
                            <button type="submit" class="button">{{ trans('common.confirm') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@stop