<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => 'Instellingen',
    'settings_save' => 'Instellingen opslaan',
    'system_version' => 'Systeem versie',
    'categories' => 'Categorieën',

    // App Settings
    'app_customization' => 'Aanpassingen',
    'app_features_security' => 'Functies en beveiliging',
    'app_name' => 'Applicatienaam',
    'app_name_desc' => 'Deze naam wordt getoond in de header en in alle door het systeem verstuurde e-mails.',
    'app_name_header' => 'Toon naam in header',
    'app_public_access' => 'Openbare toegang',
    'app_public_access_desc' => 'Door deze optie in te schakelen kunnen bezoekers die niet ingelogd zijn toegang krijgen tot de inhoud van uw BookStack-omgeving.',
    'app_public_access_desc_guest' => 'De toegang voor publieke bezoekers kan worden ingesteld via de "Guest" gebruiker.',
    'app_public_access_toggle' => 'Openbare toegang toestaan',
    'app_public_viewing' => 'Publieke bezichtigingen toestaan?',
    'app_secure_images' => 'Uploaden van afbeeldingen met hogere beveiliging',
    'app_secure_images_toggle' => 'Activeer uploaden van afbeeldingen met hogere beveiliging',
    'app_secure_images_desc' => 'Om prestatieredenen zijn alle afbeeldingen openbaar. Deze optie voegt een willekeurige en moeilijk te raden tekst toe aan de URL\'s van de afbeeldingen. Zorg ervoor dat "directory indexes" niet ingeschakeld zijn om eenvoudige toegang te voorkomen.',
    'app_default_editor' => 'Standaard Pagina Bewerker',
    'app_default_editor_desc' => 'Selecteer welke bewerker standaard zal worden gebruikt bij het bewerken van nieuwe pagina\'s. Dit kan worden overschreven op paginaniveau als de rechten dat toestaan.',
    'app_custom_html' => 'Aangepaste inhoud voor het HTML head-element',
    'app_custom_html_desc' => 'Alle hieronder toegevoegde data wordt aan het einde van de <head> sectie van elke pagina toegevoegd. Gebruik dit om stijlen te overschrijven of analytische code toe te voegen.',
    'app_custom_html_disabled_notice' => 'Bovenstaande wordt niet toegevoegd aan deze pagina om ervoor te zorgen dat je foutieve code steeds ongedaan kan maken.',
    'app_logo' => 'Applicatielogo',
    'app_logo_desc' => 'Dit wordt onder meer gebruikt in de kopbalk van de applicatie. Deze afbeelding dient 86px hoog te zijn. Grote afbeeldingen worden teruggeschaald.',
    'app_icon' => 'Applicatiepictogram',
    'app_icon_desc' => 'Dit pictogram wordt gebruikt voor browsertabbladen en snelkoppelingspictogrammen. Dit dient een 256px vierkante PNG-afbeelding te zijn.',
    'app_homepage' => 'Applicatie startpagina',
    'app_homepage_desc' => 'Selecteer een weergave om weer te geven op de startpagina in plaats van de standaard weergave. Paginamachtigingen worden genegeerd voor geselecteerde pagina\'s.',
    'app_homepage_select' => 'Selecteer een pagina',
    'app_footer_links' => 'Voettekst hyperlinks',
    'app_footer_links_desc' => 'Voeg hyperlinks toe aan de voettekst van de applicatie. Deze zullen onderaan de meeste pagina\'s getoond worden, ook aan pagina\'s die geen login vereisen. Je kunt een label van "trans::<key>" gebruiken om systeem-gedefinieerde vertalingen te gebruiken. Bijvoorbeeld: Het gebruik van "trans::common.privacy_policy" zal de vertaalde tekst "Privacy Policy" opleveren en "trans::common.terms_of_service" zal de vertaalde tekst "Gebruiksvoorwaarden" opleveren.',
    'app_footer_links_label' => 'Link label',
    'app_footer_links_url' => 'Link URL',
    'app_footer_links_add' => 'Voettekst link toevoegen',
    'app_disable_comments' => 'Opmerkingen uitschakelen',
    'app_disable_comments_toggle' => 'Opmerkingen uitschakelen',
    'app_disable_comments_desc' => 'Schakel opmerkingen uit op alle pagina\'s in de applicatie. <br> Bestaande opmerkingen worden niet getoond.',

    // Color settings
    'color_scheme' => 'Kleurenschema van applicatie',
    'color_scheme_desc' => 'Stel de kleuren in voor de gebruikersinterface van de applicatie. Kleuren kunnen afzonderlijk worden geconfigureerd voor donkere en lichte modi om zo goed mogelijk bij het thema te passen en de leesbaarheid te garanderen.',
    'ui_colors_desc' => 'Stel de primaire kleur van de applicatie en de standaard hyperlinkkleur in. De primaire kleur wordt voornamelijk gebruikt voor de headerbanner, knoppen en interfacedecoraties. De standaard hyperlinkkleur wordt gebruikt voor tekstgebaseerde links en acties, zowel binnen geschreven inhoud als in de applicatie-interface.',
    'app_color' => 'Primaire kleur',
    'link_color' => 'Standaard hyperlinkkleur',
    'content_colors_desc' => 'Stel kleuren in voor alle elementen in de hiërarchie van de pagina-organisatie. Voor de leesbaarheid is het aan te raden kleuren te kiezen met eenzelfde helderheid als de standaardkleuren.',
    'bookshelf_color' => 'Kleur van de Boekenplank',
    'book_color' => 'Kleur van het Boek',
    'chapter_color' => 'Kleur van het Hoofdstuk',
    'page_color' => 'Pagina kleur',
    'page_draft_color' => 'Concept pagina kleur',

    // Registration Settings
    'reg_settings' => 'Registratie',
    'reg_enable' => 'Registratie inschakelen',
    'reg_enable_toggle' => 'Registratie inschakelen',
    'reg_enable_desc' => 'Wanneer registratie is ingeschakeld, kunnen gebruikers zichzelf aanmelden als applicatiegebruiker. Bij registratie krijgen ze een enkele, standaard gebruikersrol.',
    'reg_default_role' => 'Standaard rol na registratie',
    'reg_enable_external_warning' => 'De optie hierboven wordt niet gebruikt terwijl externe LDAP- of SAML authenticatie actief is. Gebruikersaccounts voor niet-bestaande leden zullen automatisch worden aangemaakt wanneer authenticatie tegen het gebruikte externe systeem succesvol is.',
    'reg_email_confirmation' => 'E-mail bevestiging',
    'reg_email_confirmation_toggle' => 'E-mailbevestiging vereisen',
    'reg_confirm_email_desc' => 'Als domeinrestricties aan staan dan is e-maibevestiging altijd nodig. Onderstaande instelling wordt dan genegeerd.',
    'reg_confirm_restrict_domain' => 'Beperk registratie tot een domein',
    'reg_confirm_restrict_domain_desc' => 'Geef een door komma-gescheiden lijst van domeinnamen op die gebruikt mogen worden bij registratie. Gebruikers dienen de ontvangen e-mail te bevestigen voordat ze toegang krijgen tot de applicatie. <br>Let op: Gebruikers kunnen na registratie hun e-mailadres nog steeds wijzigen.',
    'reg_confirm_restrict_domain_placeholder' => 'Geen beperkingen ingesteld',

    // Sorting Settings
    'sorting' => 'Lijsten & Sorteren',
    'sorting_book_default' => 'Standaard Sorteerregel Boek',
    'sorting_book_default_desc' => 'Selecteer de standaard sorteerregel om toe te passen op nieuwe boeken. Dit heeft geen invloed op bestaande boeken, en kan per boek worden overschreven.',
    'sorting_rules' => 'Sorteerregels',
    'sorting_rules_desc' => 'Dit zijn vooraf ingestelde sorteeroperaties die kunnen worden toegepast op inhoud in het systeem.',
    'sort_rule_assigned_to_x_books' => 'Toegepast op :count Boek|Toegepast op :count Boeken',
    'sort_rule_create' => 'Maak sorteerregel',
    'sort_rule_edit' => 'Bewerk sorteerregel',
    'sort_rule_delete' => 'Verwijder sorteerregel',
    'sort_rule_delete_desc' => 'Verwijder deze sorteerregel uit het systeem. Boeken die deze regel gebruiken zullen terugvallen op handmatige sortering.',
    'sort_rule_delete_warn_books' => 'Deze sorteerregel wordt momenteel gebruikt door :count boek(en). Weet je zeker dat je deze wilt verwijderen?',
    'sort_rule_delete_warn_default' => 'Deze sorteerregel wordt gebruikt als standaardregel voor boeken. Weet je zeker dat je deze wilt verwijderen?',
    'sort_rule_details' => 'Details sorteerregel',
    'sort_rule_details_desc' => 'Stel een naam in voor deze sorteerregel. Deze wordt weergegeven waar gebruikers een regel kunnen selecteren.',
    'sort_rule_operations' => 'Sorteeroperaties',
    'sort_rule_operations_desc' => 'Configureer de sorteeracties die moeten worden uitgevoerd door ze te verplaatsen van de lijst met beschikbare operaties. Bij gebruik worden de operaties toegepast in volgorde van boven naar beneden. Wijzigingen die hier worden gemaakt worden toegepast op alle toegewezen boeken.',
    'sort_rule_available_operations' => 'Beschikbare Operaties',
    'sort_rule_available_operations_empty' => 'Geen operaties over',
    'sort_rule_configured_operations' => 'Ingestelde Operaties',
    'sort_rule_configured_operations_empty' => 'Voeg operaties toe uit de "Beschikbare Operaties" lijst',
    'sort_rule_op_asc' => '(Oplopend)',
    'sort_rule_op_desc' => '(Aflopend)',
    'sort_rule_op_name' => 'Naam - Alfabetisch',
    'sort_rule_op_name_numeric' => 'Naam - Numeriek',
    'sort_rule_op_created_date' => 'Aanmaakdatum',
    'sort_rule_op_updated_date' => 'Bijwerkdatum',
    'sort_rule_op_chapters_first' => 'Hoofdstukken Eerst',
    'sort_rule_op_chapters_last' => 'Hoofdstukken Laatst',
    'sorting_page_limits' => 'Weergavelimiet Per Pagina',
    'sorting_page_limits_desc' => 'Stel in hoeveel items er op een pagina worden laten zien in de verschillende lijstweergaves. Een lager aantal verbeterd de snelheid, een hoger aantal verminderd het doorklikken door pagina\'s. Een even veelvoud van 3 (18, 24, 30, etc...) wordt aanbevolen.',

    // Maintenance settings
    'maint' => 'Onderhoud',
    'maint_image_cleanup' => 'Afbeeldingen opschonen',
    'maint_image_cleanup_desc' => 'Scant pagina- en revisieinhoud om te controleren welke afbeeldingen en tekeningen momenteel worden gebruikt en welke afbeeldingen overbodig zijn. Zorg ervoor dat je een volledige database- en afbeelding back-up maakt voordat je dit uitvoert.',
    'maint_delete_images_only_in_revisions' => 'Ook afbeeldingen verwijderen die alleen in oude paginarevisies bestaan',
    'maint_image_cleanup_run' => 'Opschonen uitvoeren',
    'maint_image_cleanup_warning' => ':count potentieel ongebruikte afbeeldingen gevonden. Weet je zeker dat je deze afbeeldingen wilt verwijderen?',
    'maint_image_cleanup_success' => ':count potentieel ongebruikte afbeeldingen gevonden en verwijderd!',
    'maint_image_cleanup_nothing_found' => 'Geen ongebruikte afbeeldingen gevonden, niets verwijderd!',
    'maint_send_test_email' => 'Stuur een test e-mail',
    'maint_send_test_email_desc' => 'Dit verstuurt een test e-mail naar het e-mailadres dat je in je profiel hebt opgegeven.',
    'maint_send_test_email_run' => 'Verzend test e-mail',
    'maint_send_test_email_success' => 'E-mail verzonden naar :address',
    'maint_send_test_email_mail_subject' => 'Test E-mail',
    'maint_send_test_email_mail_greeting' => 'E-mailbezorging lijkt te werken!',
    'maint_send_test_email_mail_text' => 'Gefeliciteerd! Nu je deze e-mailmelding hebt ontvangen, lijken je e-mailinstellingen correct te zijn geconfigureerd.',
    'maint_recycle_bin_desc' => 'Verwijderde boekenplanken, boeken, hoofdstukken en pagina\'s worden naar de prullenbak gestuurd waar ze hersteld of definitief verwijderd kunnen worden. Oudere items in de prullenbak kunnen automatisch worden verwijderd, afhankelijk van de systeemconfiguratie.',
    'maint_recycle_bin_open' => 'Prullenbak openen',
    'maint_regen_references' => 'Verwijzingen opnieuw genereren',
    'maint_regen_references_desc' => 'Deze actie zal de kruisverwijzingen index binnen de database opnieuw opbouwen. Dit wordt doorgaans automatisch gedaan, maar deze actie kan nuttig zijn om oude inhoud of inhoud die via onofficiële methoden is toegevoegd te indexeren.',
    'maint_regen_references_success' => 'Verwijzingenindex is opnieuw gegenereerd!',
    'maint_timeout_command_note' => 'Let op: Het uitvoeren van deze actie kan enige tijd in beslag nemen, wat in sommige webomgevingen kan leiden tot time-outs. Als alternatief kan deze actie ook worden uitgevoerd met een terminal-commando.',

    // Recycle Bin
    'recycle_bin' => 'Prullenbak',
    'recycle_bin_desc' => 'Hier kun je items herstellen die zijn verwijderd of ervoor kiezen om ze permanent uit het systeem te verwijderen. Deze lijst is ongefilterd, in tegenstelling tot vergelijkbare activiteitenlijsten in het systeem waar machtigingenfilters worden toegepast.',
    'recycle_bin_deleted_item' => 'Verwijderde Item',
    'recycle_bin_deleted_parent' => 'Bovenliggende',
    'recycle_bin_deleted_by' => 'Verwijderd door',
    'recycle_bin_deleted_at' => 'Verwijderd op',
    'recycle_bin_permanently_delete' => 'Permanent verwijderen',
    'recycle_bin_restore' => 'Herstellen',
    'recycle_bin_contents_empty' => 'De prullenbak is momenteel leeg',
    'recycle_bin_empty' => 'Prullenbak legen',
    'recycle_bin_empty_confirm' => 'Dit zal permanent alle items in de prullenbak vernietigen, inclusief de inhoud die in elk item zit. Weet je zeker dat je de prullenbak wil legen?',
    'recycle_bin_destroy_confirm' => 'Deze actie zal dit item permanent verwijderen uit het systeem, samen met onderstaande onderliggende elementen, en u zal deze inhoud niet kunnen herstellen. Bent u zeker dat u dit item permanent wilt verwijderen?',
    'recycle_bin_destroy_list' => 'Te vernietigen items',
    'recycle_bin_restore_list' => 'Items te herstellen',
    'recycle_bin_restore_confirm' => 'Deze actie herstelt het verwijderde item, inclusief alle onderliggende elementen, op hun oorspronkelijke locatie. Als de oorspronkelijke locatie sindsdien is verwijderd en zich nu in de prullenbak bevindt, zal ook het bovenliggende item moeten worden hersteld.',
    'recycle_bin_restore_deleted_parent' => 'De bovenliggende map van dit item is ook verwijderd. Dit zal verwijderd blijven tot het bovenliggende ook hersteld is.',
    'recycle_bin_restore_parent' => 'Herstel bovenliggende',
    'recycle_bin_destroy_notification' => ':count items uit de prullenbak verwijderd.',
    'recycle_bin_restore_notification' => ':count items uit de prullenbak hersteld.',

    // Audit Log
    'audit' => 'Controlelogboek',
    'audit_desc' => 'Dit controle logboek toont een lijst van activiteiten die in het systeem zijn bijgehouden. Deze lijst is ongefilterd in tegenstelling tot soortgelijke activiteitenlijsten in het systeem waar machtigingfilters worden toegepast.',
    'audit_event_filter' => 'Gebeurtenis filter',
    'audit_event_filter_no_filter' => 'Geen filter',
    'audit_deleted_item' => 'Verwijderd Item',
    'audit_deleted_item_name' => 'Naam: :name',
    'audit_table_user' => 'Gebruiker',
    'audit_table_event' => 'Gebeurtenis',
    'audit_table_related' => 'Gerelateerd Item of Detail',
    'audit_table_ip' => 'IP-adres',
    'audit_table_date' => 'Activiteit datum',
    'audit_date_from' => 'Datum bereik vanaf',
    'audit_date_to' => 'Datum bereik tot',

    // Role Settings
    'roles' => 'Rollen',
    'role_user_roles' => 'Gebruikersrollen',
    'roles_index_desc' => 'Rollen worden gebruikt om gebruikers te groeperen en systeemrechten te geven. Wanneer een gebruiker lid is van meerdere rollen worden de toegekende rechten samengevoegd en erft de gebruiker alle mogelijkheden.',
    'roles_x_users_assigned' => ':count gebruiker toegewezen|:count gebruikers toegewezen',
    'roles_x_permissions_provided' => ':count machtiging|:count machtigingen',
    'roles_assigned_users' => 'Toegewezen Gebruikers',
    'roles_permissions_provided' => 'Verleende Machtigingen',
    'role_create' => 'Nieuwe Rol Maken',
    'role_delete' => 'Rol Verwijderen',
    'role_delete_confirm' => 'Dit verwijdert de rol met naam: \':roleName\'.',
    'role_delete_users_assigned' => 'Er zijn :userCount gebruikers met deze rol. Selecteer hieronder een nieuwe rol als je deze gebruikers een andere rol wilt geven.',
    'role_delete_no_migration' => "Geen gebruikers migreren",
    'role_delete_sure' => 'Weet je zeker dat je deze rol wilt verwijderen?',
    'role_edit' => 'Rol Bewerken',
    'role_details' => 'Rol Details',
    'role_name' => 'Rolnaam',
    'role_desc' => 'Korte beschrijving van de rol',
    'role_mfa_enforced' => 'Meervoudige verificatie verreist',
    'role_external_auth_id' => 'Externe authenticatie ID\'s',
    'role_system' => 'Systeem Machtigingen',
    'role_manage_users' => 'Gebruikers beheren',
    'role_manage_roles' => 'Beheer rollen & machtigingen',
    'role_manage_entity_permissions' => 'Beheer alle machtigingen voor boeken, hoofdstukken en pagina\'s',
    'role_manage_own_entity_permissions' => 'Beheer machtigingen van je eigen boek, hoofdstuk & pagina\'s',
    'role_manage_page_templates' => 'Paginasjablonen beheren',
    'role_access_api' => 'Ga naar systeem API',
    'role_manage_settings' => 'Beheer app instellingen',
    'role_export_content' => 'Exporteer inhoud',
    'role_import_content' => 'Importeer inhoud',
    'role_editor_change' => 'Wijzig pagina bewerker',
    'role_notifications' => 'Meldingen ontvangen & beheren',
    'role_permission_note_users_and_roles' => 'Deze machtigingen geven technisch gezien toegang tot het weergeven van gebruikers & rollen binnen het systeem.',
    'role_asset' => 'Asset Machtigingen',
    'roles_system_warning' => 'Wees ervan bewust dat toegang tot een van de bovengenoemde drie machtigingen een gebruiker in staat kan stellen zijn eigen machtigingen of de machtigingen van anderen in het systeem kan wijzigen. Wijs alleen rollen toe met deze machtigingen aan vertrouwde gebruikers.',
    'role_asset_desc' => 'Deze machtigingen bepalen de standaard toegang tot de assets binnen het systeem. Machtigingen op boeken, hoofdstukken en pagina\'s overschrijven deze instelling.',
    'role_asset_admins' => 'Beheerders krijgen automatisch toegang tot alle inhoud, maar deze opties kunnen gebruikersinterface opties tonen of verbergen.',
    'role_asset_image_view_note' => 'Dit heeft betrekking op de zichtbaarheid binnen de afbeeldingsbeheerder. De werkelijke toegang tot geüploade afbeeldingsbestanden hangt af van de gekozen opslagmethode.',
    'role_asset_users_note' => 'Deze machtigingen geven technisch gezien toegang tot het weergeven van gebruikers binnen het systeem.',
    'role_all' => 'Alles',
    'role_own' => 'Eigen',
    'role_controlled_by_asset' => 'Gecontroleerd door de asset waar deze is geüpload',
    'role_save' => 'Rol Opslaan',
    'role_users' => 'Gebruikers in deze rol',
    'role_users_none' => 'Geen enkele gebruiker heeft deze rol',

    // Users
    'users' => 'Gebruikers',
    'users_index_desc' => 'Creëer en beheer individuele gebruikersaccounts binnen het systeem. Gebruikersaccounts worden gebruikt voor aanmelding en toekenning van inhoud en activiteiten. Toegangsmachtigingen zijn voornamelijk gebaseerd op rollen, maar het eigendom van gebruikersinhoud en andere factoren kunnen ook van invloed zijn op machtigingen en toegang.',
    'user_profile' => 'Gebruikersprofiel',
    'users_add_new' => 'Gebruiker toevoegen',
    'users_search' => 'Gebruiker zoeken',
    'users_latest_activity' => 'Laatste activiteit',
    'users_details' => 'Gebruiker details',
    'users_details_desc' => 'Stel een weergavenaam en e-mailadres in voor deze gebruiker. Het e-mailadres zal worden gebruikt om in te loggen.',
    'users_details_desc_no_email' => 'Stel een weergavenaam in voor deze gebruiker zodat anderen deze kunnen herkennen.',
    'users_role' => 'Gebruikersrollen',
    'users_role_desc' => 'Selecteer aan welke rollen deze gebruiker zal worden toegewezen. Als een gebruiker aan meerdere rollen wordt toegewezen, worden de machtigingen van die rollen samengevoegd en krijgt hij alle mogelijkheden van de toegewezen rollen.',
    'users_password' => 'Wachtwoord gebruiker',
    'users_password_desc' => 'Stel een wachtwoord in om op de applicatie in te loggen. Dit moet minstens 8 tekens lang zijn.',
    'users_send_invite_text' => 'Je kunt ervoor kiezen om deze gebruiker een uitnodigingsmail te sturen waarmee hij zijn eigen wachtwoord kan instellen, anders kun je zelf zijn wachtwoord instellen.',
    'users_send_invite_option' => 'Stuur gebruiker uitnodigings e-mail',
    'users_external_auth_id' => 'Externe authenticatie ID',
    'users_external_auth_id_desc' => 'Wanneer een extern authenticatiesysteem wordt gebruikt (zoals SAML2, OIDC of LDAP) is dit de ID die deze BookStack-gebruiker koppelt aan het account van het authenticatiesysteem. Je kunt dit veld negeren als je de standaard op e-mail gebaseerde verificatie gebruikt.',
    'users_password_warning' => 'Vul onderstaande velden alleen in als je het wachtwoord voor deze gebruiker wil wijzigen.',
    'users_system_public' => 'Deze gebruiker vertegenwoordigt alle gastgebruikers die uw applicatie bezoeken. Hij kan niet worden gebruikt om in te loggen, maar wordt automatisch toegewezen.',
    'users_delete' => 'Verwijder gebruiker',
    'users_delete_named' => 'Verwijder gebruiker :userName',
    'users_delete_warning' => 'Dit zal de gebruiker \':userName\' volledig uit het systeem verwijderen.',
    'users_delete_confirm' => 'Weet je zeker dat je deze gebruiker wilt verwijderen?',
    'users_migrate_ownership' => 'Draag eigendom over',
    'users_migrate_ownership_desc' => 'Selecteer een gebruiker hier als u wilt dat een andere gebruiker de eigenaar wordt van alle items die momenteel eigendom zijn van deze gebruiker.',
    'users_none_selected' => 'Geen gebruiker geselecteerd',
    'users_edit' => 'Bewerk Gebruiker',
    'users_edit_profile' => 'Bewerk Profiel',
    'users_avatar' => 'Avatar',
    'users_avatar_desc' => 'Selecteer een afbeelding om deze gebruiker voor te stellen. Deze moet ongeveer 256px breed en vierkant zijn.',
    'users_preferred_language' => 'Voorkeurstaal',
    'users_preferred_language_desc' => 'Deze optie wijzigt de taal die gebruikt wordt voor de gebruikersinterface. Dit heeft geen invloed op door gebruikers gemaakte inhoud.',
    'users_social_accounts' => 'Sociale media accounts',
    'users_social_accounts_desc' => 'Bekijk de status van de verbonden socialmedia-accounts voor deze gebruiker. socialmedia-accounts kunnen worden gebruikt naast het primaire authenticatiesysteem voor systeemtoegang.',
    'users_social_accounts_info' => 'Hier kun je je andere accounts koppelen om sneller en eenvoudiger in te loggen. Als je hier een account loskoppelt, wordt de eerder gemachtigde toegang niet ingetrokken. Je kunt de toegang intrekken via je profielinstellingen op het gekoppelde socialemedia-account zelf.',
    'users_social_connect' => 'Account Verbinden',
    'users_social_disconnect' => 'Account Ontkoppelen',
    'users_social_status_connected' => 'Verbonden',
    'users_social_status_disconnected' => 'Verbroken',
    'users_social_connected' => ':socialAccount account succesvol aan je profiel gekoppeld.',
    'users_social_disconnected' => ':socialAccount account succesvol ontkoppeld van je profiel.',
    'users_api_tokens' => 'API-Tokens',
    'users_api_tokens_desc' => 'Creëer en beheer de toegangstokens die gebruikt worden om te authenticeren met de BookStack REST API. Machtigingen voor de API worden beheerd via de gebruiker waartoe het token behoort.',
    'users_api_tokens_none' => 'Er zijn geen API-tokens gemaakt voor deze gebruiker',
    'users_api_tokens_create' => 'Token aanmaken',
    'users_api_tokens_expires' => 'Verloopt',
    'users_api_tokens_docs' => 'API-Documentatie',
    'users_mfa' => 'Meervoudige Verificatie',
    'users_mfa_desc' => 'Stel meervoudige verificatie in als extra beveiligingslaag voor je gebruikersaccount.',
    'users_mfa_x_methods' => ':count methode geconfigureerd|:count methoden geconfigureerd',
    'users_mfa_configure' => 'Configureer methoden',

    // API Tokens
    'user_api_token_create' => 'API-token aanmaken',
    'user_api_token_name' => 'Naam',
    'user_api_token_name_desc' => 'Geef je token een leesbare naam als een toekomstige herinnering aan het beoogde doel.',
    'user_api_token_expiry' => 'Vervaldatum',
    'user_api_token_expiry_desc' => 'Stel een datum in waarop deze token verloopt. Na deze datum zullen aanvragen die met deze token zijn ingediend niet langer werken. Als dit veld leeg blijft, wordt een vervaldatum van 100 jaar in de toekomst ingesteld.',
    'user_api_token_create_secret_message' => 'Onmiddellijk na het aanmaken van dit token zal een "Token ID" en "Token Geheim" worden gegenereerd en weergegeven. Het geheim zal slechts één keer getoond worden. Kopieer de waarde dus eerst op een veilige plaats voordat u doorgaat.',
    'user_api_token' => 'API-Token',
    'user_api_token_id' => 'Token ID',
    'user_api_token_id_desc' => 'Dit is een niet-wijzigbare, door het systeem gegenereerde identificatiecode voor dit token, die in API-verzoeken moet worden verstrekt.',
    'user_api_token_secret' => 'Geheime token sleutel',
    'user_api_token_secret_desc' => 'Dit is een door het systeem gegenereerd geheim voor dit token dat in API-verzoeken zal moeten worden verstrekt. Dit zal slechts één keer worden weergegeven, dus kopieer deze waarde naar een veilige plaats.',
    'user_api_token_created' => 'Token :timeAgo geleden aangemaakt',
    'user_api_token_updated' => 'Token :timeAgo geleden bijgewerkt',
    'user_api_token_delete' => 'Token Verwijderen',
    'user_api_token_delete_warning' => 'Dit zal de API-token met de naam \':tokenName\' volledig uit het systeem verwijderen.',
    'user_api_token_delete_confirm' => 'Weet je zeker dat je deze API-token wilt verwijderen?',

    // Webhooks
    'webhooks' => 'Webhooks',
    'webhooks_index_desc' => 'Webhooks zijn een manier om gegevens naar externe URL\'s te sturen wanneer bepaalde acties en gebeurtenissen in het systeem plaatsvinden, wat op gebeurtenissen gebaseerde integratie met externe platforms zoals berichten- of notificatiesystemen mogelijk maakt.',
    'webhooks_x_trigger_events' => ':count trigger event|:count trigger events',
    'webhooks_create' => 'Nieuwe Webhook Maken',
    'webhooks_none_created' => 'Er zijn nog geen webhooks aangemaakt.',
    'webhooks_edit' => 'Bewerk Webhook',
    'webhooks_save' => 'Webhook opslaan',
    'webhooks_details' => 'Webhook Details',
    'webhooks_details_desc' => 'Geef een gebruiksvriendelijke naam en een POST eindpunt op als locatie waar de webhook gegevens naartoe gestuurd zullen worden.',
    'webhooks_events' => 'Webhook gebeurtenissen',
    'webhooks_events_desc' => 'Selecteer alle gebeurtenissen die deze webhook dient te activeren.',
    'webhooks_events_warning' => 'Houd er rekening mee dat deze gebeurtenissen zullen worden geactiveerd voor alle geselecteerde gebeurtenissen, zelfs als aangepaste machtigingen zijn toegepast. Zorg ervoor dat het gebruik van deze webhook geen vertrouwelijke inhoud blootlegt.',
    'webhooks_events_all' => 'Alle systeemgebeurtenissen',
    'webhooks_name' => 'Webhook Naam',
    'webhooks_timeout' => 'Webhook Verzoek Time-out (Seconden)',
    'webhooks_endpoint' => 'Webhook Eindpunt',
    'webhooks_active' => 'Webhook Actief',
    'webhook_events_table_header' => 'Gebeurtenissen',
    'webhooks_delete' => 'Verwijder Webhook',
    'webhooks_delete_warning' => 'Dit zal de webhook met naam \':webhookName\' volledig verwijderen van het systeem.',
    'webhooks_delete_confirm' => 'Weet je zeker dat je deze webhook wilt verwijderen?',
    'webhooks_format_example' => 'Voorbeeld Webhook Formaat',
    'webhooks_format_example_desc' => 'Webhook gegevens worden verzonden als een POST verzoek naar het geconfigureerde eindpunt als JSON volgens het onderstaande formaat. De "related_item" en "url" eigenschappen zijn optioneel en hangen af van het type gebeurtenis die geactiveerd wordt.',
    'webhooks_status' => 'Webhook Status',
    'webhooks_last_called' => 'Laatst Opgeroepen:',
    'webhooks_last_errored' => 'Laatst Gefaald:',
    'webhooks_last_error_message' => 'Laatste Foutmelding:',

    // Licensing
    'licenses' => 'Licenties',
    'licenses_desc' => 'Deze pagina beschrijft licentie-informatie voor BookStack naast de projecten & bibliotheken die binnen BookStack worden gebruikt. Veel van de vermelde projecten worden alleen in een ontwikkelingscontext gebruikt.',
    'licenses_bookstack' => 'BookStack Licentie',
    'licenses_php' => 'PHP Bibliotheek Licenties',
    'licenses_js' => 'JavaScript Bibliotheek Licenties',
    'licenses_other' => 'Andere Licenties',
    'license_details' => 'Licentie Details',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'Engels',
        'ar' => 'العربية (Arabisch)',
        'bg' => 'Bǎlgarski (Bulgaars)',
        'bs' => 'Bosanski (Bosnisch)',
        'ca' => 'Català (Catalaans)',
        'cs' => 'Česky (Tsjechisch)',
        'cy' => 'Cymraeg',
        'da' => 'Dansk (Deens)',
        'de' => 'Deutsch (Duits)',
        'de_informal' => 'Deutsch (Du) (Informeel Duits)',
        'el' => 'ελληνικά',
        'es' => 'Español (Spaans)',
        'es_AR' => 'Español Argentina (Argentijns Spaans)',
        'et' => 'Eesti keel (Estisch)',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français (Frans)',
        'he' => 'עברית (Hebreeuws)',
        'hr' => 'Hrvatski (Kroatisch)',
        'hu' => 'Magyar (Hongaars)',
        'id' => 'Bahasa Indonesia (Indonesisch)',
        'it' => 'Italiano (Italiaans)',
        'ja' => '日本語 (Japans)',
        'ko' => '한국어 (Koreaans)',
        'lt' => 'Lietuvių Kalba (Litouws)',
        'lv' => 'Latviešu Valoda (Lets)',
        'nb' => 'Norsk (Bokmål) (Noors)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski (Pools)',
        'pt' => 'Português (Portugees)',
        'pt_BR' => 'Português do Brasil (Braziliaans-Portugees)',
        'ro' => 'Română',
        'ru' => 'Русский (Russisch)',
        'sk' => 'Slovensky (Slowaaks)',
        'sl' => 'Slovenščina (Sloveens)',
        'sv' => 'Svenska (Zweeds)',
        'tr' => 'Türkçe (Turks)',
        'uk' => 'Українська (Oekraïens)',
        'uz' => 'Oezbeeks',
        'vi' => 'Tiếng Việt (Vietnamees)',
        'zh_CN' => '简体中文 (Chinees)',
        'zh_TW' => '繁體中文 (Traditioneel Chinees)',
    ],
    //!////////////////////////////////
];
